/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GridStackFluid
implements IGridStack {
    private final UUID id;
    @Nullable
    private UUID otherId;
    private final FluidStack stack;
    private long count;
    @Nullable
    private StorageTrackerEntry entry;
    private final boolean craftable;
    private String modId;
    private String modName;

    public GridStackFluid(UUID id, @Nullable UUID otherId, FluidStack stack, long count, @Nullable StorageTrackerEntry entry, boolean craftable) {
        this.id = id;
        this.otherId = otherId;
        this.stack = stack;
        this.count = count;
        this.entry = entry;
        this.craftable = craftable;
    }

    @Override
    @Nullable
    public UUID getOtherId() {
        return this.otherId;
    }

    @Override
    public void updateOtherId(@Nullable UUID otherId) {
        this.otherId = otherId;
    }

    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public String getModId() {
        if (this.modId == null) {
            this.modId = FluidRegistry.getModId((FluidStack)this.stack);
            if (this.modId == null) {
                this.modId = "???";
            }
        }
        return this.modId;
    }

    @Override
    public String getModName() {
        if (this.modName == null) {
            this.modName = GridStackItem.getModNameByModId(this.getModId());
            if (this.modName == null) {
                this.modName = "???";
            }
        }
        return this.modName;
    }

    @Override
    public String[] getOreIds() {
        return new String[]{this.stack.getFluid().getName()};
    }

    @Override
    public String getTooltip(boolean cached) {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public long getQuantity() {
        return this.isCraftable() ? 0L : this.getCount();
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public void grow(long count) {
        this.count += count;
    }

    @Override
    public String getFormattedFullQuantity() {
        return API.instance().getQuantityFormatter().format(this.getQuantity()) + " mB";
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        GuiBase.FLUID_RENDERER.draw(gui.field_146297_k, x, y, this.stack);
        String text = this.isCraftable() ? I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]) : API.instance().getQuantityFormatter().formatInBucketFormWithOnlyTrailingDigitsIfZero(this.getQuantity());
        gui.drawQuantity(x, y, text);
    }

    @Override
    public Object getIngredient() {
        return this.getStack();
    }

    @Override
    @Nullable
    public StorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable StorageTrackerEntry entry) {
        this.entry = entry;
    }
}

